---
Creation date: 2024-02-06
Last modified: 2024-07-18
---

# What is Obsidian?

Obsidian is a personal knowledge management software application that enables a high degree of flexibility in both note taking and note organising. If you're new to Obsidian, I recommend checking out their [official documentation](https://help.obsidian.md/Home) to get familiar with the basics of the app.

One key difference between Obsidian and Notion (which I previously used for my PKM) is that Obsidian is built on plain text Markdown files stored locally on your computer. This gives you complete ownership and control over your data, and ensures your notes will always be accessible and future-proof. However, it does mean sacrificing some of the slick UI and collaboration features of a web-based tool like Notion.

Additionally, there is a strong open-source community built up around the core Obsidian software, which provides a wide variety of plugins to augment Obsidian's capabilities for specific purposes. The Academic PKM Template comes pre-loaded with the plugins that I find indispensable for academic workflows (detailed below).

# The Academic PKM Template

This guide will walk you through my Obsidian system which I've developed for managing my own work and life as an academic researcher. I've included some example notes to demonstrate the structure of my system, but you can delete these and replace them with your notes in your own Obsidian vault. The key is to experiment and iterate to find the workflows that fit your unique needs and thinking style, so I hope the Academic PKM Template can be a useful jumping-off point for your own approach.

## Template contents

- My system of interlinked databases: Areas, Projects, Tasks, Maps of Content, References, Zettelkasten, Meeting notes, Resources, and Rolodex.
- Custom scripts to automate the interlinking of these databases.
- A suite of pre-configured plugins developed by the Obsidian community that I find indispensable for my work, including the [Obsidian Zotero Integration](https://github.com/mgmeyers/obsidian-zotero-integration), [Dataview](https://github.com/blacksmithgu/obsidian-dataview), [Metadata Menu](https://github.com/mdelobelle/metadatamenu), and [Linter](https://github.com/platers/obsidian-linter).
- Example notes to demonstrate the structure of the system.

## How to install the Academic PKM Template

Upon purchase you will receive a link to download a zip file of the Academic PKM Template. This template is designed specifically for [Obsidian](https://obsidian.md/), a free note-taking app built on plain text Markdown files stored locally on your computer. If you don't already have Obsidian you can download it from [this link](https://obsidian.md/download). To install the Academic PKM Template:

1. Unzip the Academic PKM Template zip file and save it as a folder on your device (I recommend saving it to a file synchronisation service if you use one, like Dropbox, Google Drive or OneDrive, to benefit from automatic back-ups and version history.)
2. Open the Obsidian application and click the "Open another vault" button in the bottom left corner.
3. Select the "Open folder as vault" option and select the folder you created for the Academic PKM Template.
4. When you first open this folder, you will be asked if you trust the author of this vault. You'll need to select "Trust author and enable plugins" for the Academic PKM Template. (Otherwise the vault will open in "Restricted Mode" meaning the community plugins won't work.)

## Structure of the Academic PKM Template

The primary components of the Academic PKM Template are the interconnected databases designed for managing all aspects of work and life as an academic. These databases contain notes of different types that relate to one another via custom [metadata](https://help.obsidian.md/Editing+and+formatting/Properties), and are grouped according to three families.

### Three interconnected databases

#### Actionable

- **Areas**: Areas represent the ongoing responsibilities and spheres of activity in my life, such as teaching, research, academic service, family, etc. This folder contains overview notes for each area, and these notes in turn link to the projects, tasks, resources, etc. that relate to this area. I use the [Dataview](https://github.com/blacksmithgu/obsidian-dataview) plugin to present filtered views of related databases - for instances, tasks that relate to the area in question.
- **Projects**: Projects are focused endeavours with a specific goal and end point, like writing a paper or planning a conference. Each project gets its own note where I collect all relevant tasks, ideas, references, and resources.
- **Tasks**: Tasks are specific, defined actions. Each task note includes metadata like due date, priority level, associated project or area, etc.

#### Knowledge management system

- **References**: This folder contains literature notes, with each note representing a paper, book, or other source I've read and want to capture. I use metadata like author, year, and related project to make it easy to search and filter my references later.
- **Zettelkasten**: This is where I keep my atomic "zettels" - discrete notes containing a single idea, insight, or argument derived from my reading, thinking, and writing. These notes link to the relevant literature references as well as to other related zettels, forming a dense web of interconnected knowledge over time. See more on my Zettelkasten workflow below.
- **Maps of content (MoCs)**: MoCs are emerging notes that curate and stitch together content from my Zettelkasten to help me navigate my knowledge base, develop my thinking on a topic, and outline writing projects. Each offers one possible way of structuring my knowledge management system without implying that this is the *only* way the system can be structured or requiring that this structure be reproduced going forward.

#### Project management system

- **Resources**: Of course academic references are not the only resources we need to keep track of in academic work - the Resources database offers a place to store admin documents, webpages, important emails, etc.
- **Meeting notes**: Meetings notes are a type of resource, a key element of any collaborative project or area, so I've found it important to keep these Resource notes in their own database.
- **Rolodex**: These "people notes" help me keep track of information about particular people, from those I work with day-to-day to those long-dead scholars I engage with in my writing.

### Other elements of the Academic PKM Template

#### Home

The [[Home]] page is designed to serve as day-to-day "working memory" as well as offering a customisable entry point to other aspects of the system. It uses the [Dataview](https://github.com/blacksmithgu/obsidian-dataview) plugin to present views of the above databases filtered to display just the most relevant notes - for instance, tasks yet to be done with a do date on (or before) today's date.

#### Obsidian Admin

This folder contains all of the bits and bobs needed for the system to run, like the icons that help distinguish one type of note from another, and the templates that determine what sorts of metadata and content structure is used for each note type.

## Key actions

### Navigating your Obsidian vault

Beyond the [[Home]] page, there are a variety of ways of finding any given note you need in Obsidian:

- **Sidebar:** The left side-bar contains a 'Files' tab that lets you see all of the contents of your vault in nested and colour-coded folders.
- **Search command:** You can search your entire vault using the [Omnisearch](https://github.com/scambier/obsidian-omnisearch) plugin (hotkey: Cmd + Shift + F)
- **Dataviews:** The Academic PKM Template includes a variety of note templates corresponding to each of the databases detailed above. Many of these templates make use of the [Dataview](https://github.com/blacksmithgu/obsidian-dataview) plugin to pull in other relevant notes (e.g. past meetings with this person, resources relevant to this project, etc.) This is often a good place to find what you need.
- **Projects:** The [Projects](https://github.com/marcusolsson/obsidian-projects) plugin offers kanban, calendar and table views of each database.

 ![[Projects - tasks do date calendar.png|1000]]

### Obsidian commands

Obsidian is designed for efficiency, so most actions can be performed without taking your fingers off the keyboard. You can open the Obsidian [command palette](https://help.obsidian.md/Plugins/Command+palette) at any time by quickly double-tabbing the shift key on your keyboard. For frequent actions, you can also set custom keyboard shortcuts or "[hotkeys](https://help.obsidian.md/User+interface/Hotkeys)". Open the Obsidian settings to find the relevant hotkeys for you.

![[Hotkeys.png|1000]]

### Inserting a template into a new note

Custom [templates](https://help.obsidian.md/Plugins/Templates) are a key part of the Academic PKM system. There are specific templates corresponding to each of the above databases to enable quickly capturing new tasks, resources, zettels, etc. with consistent formatting and metadata - what Obsidian calls "[properties](https://help.obsidian.md/Editing+and+formatting/Properties)". These metadata fields are used by the [Dataview](https://github.com/blacksmithgu/obsidian-dataview) plugin to present relevant database entries throughout your vault - this is how the above databases are interconnected. To create a new note using one of these templates:

1. Create a new note (Cmd + N).
2. Open the command palette (double-press the shift key).
3. Start typing the word "template" into the search bar to get the "Templates: Insert Template" command, and hit enter.
4. Start typing the template you want until it appears in the search bar and hit enter.

The page will then fill with relevant metadata for the selected note type. The [Auto Note Mover](https://github.com/farux/obsidian-auto-note-mover) plugin will file this note in the appropriate folder based on the metadata pre-filled by the template.

![[Screenshot 2024-05-27 at 14.00.38.png|1000]]

To connect notes between your various databases using the [properties](https://help.obsidian.md/Editing+and+formatting/Properties) metadata fields either:
- click the 🔗 icon alongside the relevant property and select the page you want to link to from the drop-down list
  OR
- type the [wikilink](https://help.obsidian.md/Linking+notes+and+files/Internal+links) to the page directly into the relevant property field

![[Linking via properties 1.png|1000]]

These templates can be further customise to suit your own needs. For instance, I created a specific [[Task template - teaching session prep|task template for teaching session prep]] because preparing for a teaching session is something I have to do very regularly in my job role, and it comprises multiple sub-steps that I need to remember every time.

![[Screenshot 2024-05-26 at 10.13.50.png|500]]

## Example workflows

### Impromptu meeting with a colleague

A key purpose of my Academic PKM system is to ensure I always have the correct information to hand at any given moment. When working on a specific project, for instance, you need to have to hand certain general information, as well as any completed or outstanding tasks related to that project, relevant meeting notes, etc. Example notes like [[SOC101 Introduction to Sociology Course]] demonstrate this feature of the Academic PKM Template:
![[Screenshot 2024-05-27 at 14.04.01.png|800]]

Taking a specific example of how this might enhance your workflow, often we have impromptu meetings with colleagues with whom we work on multiple projects. Rather than jumping around between different project folders and searching for half-remembered documents, the Academic PKM system allows you to call up your note for that colleague in the rolodex database, which is pre-populated with links to every note relating to that colleague across all of the databases. In this example vault I've created an imaginary colleague "[[Valerie Nguyen]]" to illustrate this workflow. When Valerie calls to my office, I'll first open up her [[Valerie Nguyen|rolodex note]] so I can quickly reference any information she might need regarding, for instance, our shared projects, relevant tasks I'm working on, notes on meetings we've recently attended together, etc.

![[Screenshot 2024-05-26 at 15.36.59.png|500]]

As we chat, I'll use the "Fleeting notes" section of the [[Valerie Nguyen]] file as a handy sport to jot things down, to be subsequently processed into the appropriate location and format. For instance, if Valerie asks me to do something for her, I'll first quickly note down any details of the request here, and then move this information into a stand alone Task note using the [[Task template]]. Alternatively, I can use one of my [[#Create a child note from parent note|custom scripts]] (detailed below) to create a "child" Task note with relevant metadata auto-populated from the "parent" Person note:

![[Create child note from parent note demonstration.png|1000]]

Regardless of which method is used to create the new task, its "due date" and "do date" will be set to today's date by default to ensure it doesn't get lost. This means that it will appear on the [[Home]] page under [[Home#To do lists|To do lists]] at the top of the "Today's tasks" dataview table until I intentionally update this metadata. This means "Today's tasks" effectively does double duty as both today's to do list and my task inbox:

![[To do list inbox.png|1000]]

### Extracting insights from academic literature

Niklas Luhmann's [Zettelkasten method](https://jdboelter.blogspot.com/2019/03/what-is-best-way-to-take-notes-quora.html) is at the heart of my knowledge management system. It involves creating a network of interconnected notes (zettels) that can be easily accessed, modified and interlinked. This method facilitates deep understanding and creative thinking by organising information in a flexible and intuitive manner. I primarily expand and deepen my zettelkasten through engagement with academic literature relevant to one of my work-in-progress research papers.

Because there's never enough time for this part of an academic's work, it's crucial to streamline this process as much as possible. I've therefore built my knowledge management system around the [Zotero Integration](https://github.com/mgmeyers/obsidian-zotero-integration) plugin, which allows me to pull into Obsidian my own notes on any given source in my Zotero reference manager library, automatically formatting these notes in a manner designed to optimise their usability in my academic writing workflow. (The Zotero Integration plugin is already installed and configured in this vault - if you want to make use of this integration all you need to do is ensure you have both [Zotero](https://www.zotero.org/) and the [Better BibTeX for Zotero](https://retorque.re/zotero-better-bibtex/installation/) plugin installed).

In practical terms, this means that I read the source using Zotero's own [PDF reader](https://www.zotero.org/support/pdf_reader), using the Notes pane to pull out useful quotations and write my own annotations. I then move over to Obsidian where I use the [Zotero Integration](https://github.com/mgmeyers/obsidian-zotero-integration) plugin to import those reference notes from Zotero (open command palette, select "Import reference from Zotero using Zotero Integration", and find the reference using the Zotero citation search box that appears).

![[Zotero import demonstration.png|700]]

Along with the annotations themselves, the resulting Reference note auto-populates the relevant metadata from Zotero (like title, year of publication, etc.). I've configured the [Linter](https://github.com/platers/obsidian-linter) plugin to tidy up the formatting of pages like these, triggered by saving the page (Cmd + S). (Note that, for now, it does not seem possible to auto-import images from Zotero's markdown notes, so these need to be copied and pasted into the Obsidian note manually.)

I then use the [Outgoing links](https://help.obsidian.md/Plugins/Outgoing+links) core plugin to identify and link mentions in these annotations of zettels or references already in my knowledge management system:

![[Unlinked mentions.png|800]]

Where useful, I'll expand those mentioned Zettel notes with insights and/or quotations from the new reference. Often the new reference will also warrant the creation of one or two brand new Zettel notes, which can be added using the Zettel template (or, again, the [[#Create a child note from parent note|custom script]] "Create zettel from parent note", which auto-populates the link back to the source Reference note).

## Custom scripts for the Academic PKM Template

The Academic PKM Template is specifically designed for academic workflows, so it includes some custom scripts that I've developed using the [Templater](https://github.com/SilentVoid13/Templater) plugin to streamline and automate workflows that are quite unique to this form of knowledge work.

### Create a child note from parent note

I mentioned above a few of these custom scripts that automate the interlinking of the Academic PKM Template databases by pre-populating relevant properties. From within any specific note, triggering one of these scripts allows you to create a "child" note of any type that will "inherit" relevant metadata from the note in question. To trigger one of these scripts, use the "Open Insert Template modal" Templater hotkey (on MacOS, this is Option + T). You can then use the dialog box that opens to search for the relevant script:

![[Screenshot 2024-05-27 at 14.26.12.png|600]]

I find this particularly useful for creating tasks from within e.g. a project note, as it will auto-populate metadata like the relevant project, area, and meeting notes:

![[Create task note from project note demonstration.png|1000]]

### Link to external file

While I like to keep my own information in Obsidian as far as possible, there are of course many types of files that you'll prefer to store elsewhere. For me this includes, for instance, Excel files, Word files I'm collaborating on with colleagues, etc. To incorporate these resources into my Academic PKM system, I use [symlinks](https://help.obsidian.md/Files+and+folders/Symbolic+links+and+junctions) to link to these files saved locally on my computer or on Dropbox. Because the formatting of symlinks is a little fiddly, I created a custom script - [[Link to external file]] - to automate the correct formatting. To trigger this script, use the "Open Insert Template modal" Templater hotkey again (on MacOS, this is Option + T), and in the dialog box that opens search for "Link to external file". The system will then ask you to enter the file path for the file in question. Copy the file path from your computer file system (e.g., [on MacOS](https://www.idownloadblog.com/2023/02/17/how-to-copy-file-folder-pathname-finder/), right-click the file in Finder to open the contextual menu and use the Option key to reveal the "Copy File name as Pathname" option).

![[Link to external file demonstration.png|1000]]
